#include <iostream>
#include <cstdio>
#include <cmath>
#include <vector>
#include <string>
#include <map>
#include <set>
#include <algorithm>
#include <bitset>

using namespace std;

const int MAXN = 20 * 1000 + 5, MAXM = 100 * 1000 + 5, INF = 2000 * 1000 * 1000 + 5;
int d[MAXN];
bitset<MAXN> bs[MAXN], path;
char used[MAXN], col[MAXN], br[MAXN];
vector< pair<int, pair<int, int> > > g[MAXN];
set< pair<int, int> > st;
vector<int> ans;

void dfs0(int v) {
    used[v] = true;
    col[v] = true;
    for(size_t i = 0; i < g[v].size(); i++) {
        int u = g[v][i].first, w = g[v][i].second.first;
        if(!used[u] && d[u] + w == d[v])
            dfs0(u);
    }
}

void dfs(int v, int p) {
    used[v] = true;
    if(col[v])
        bs[v][v] = true;
    path[v] = true;
    for(size_t i = 0; i < g[v].size(); i++) {
        int u = g[v][i].first, w = g[v][i].second.first, id = g[v][i].second.second;
        if(id == p)
            continue;
        if(col[v] && used[u] && d[u] + w == d[v])
            bs[v][u] = true;
        else if(!used[u] && d[v] + w == d[u]) {
            dfs(u, id);
            if(!(bs[u] & path).any())
                br[id] = true;
            bs[v] |= bs[u];
        }
    }
    path[v] = false;
}

bool getPath(int v, int t) {
    used[v] = true;
    if(v == t)
        return true;
    for(size_t i = 0; i < g[v].size(); i++) {
        int u = g[v][i].first, w = g[v][i].second.first, id = g[v][i].second.second;
        if(d[v] + w != d[u] || used[u])
            continue;
        if(getPath(u, t)) {
            if(br[id])
                ans.push_back(id);
            return true;
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    int n, m;
    cin >> n >> m;
    for(int i = 0; i < m; i++) {
        int v, u, w;
        cin >> v >> u >> w;
        v--;
        u--;
        g[v].push_back(make_pair(u, make_pair(w, i)));
        g[u].push_back(make_pair(v, make_pair(w, i)));
    }
    for(int i = 0; i < n; i++)
        d[i] = INF;
    d[0] = 0;
    st.insert(make_pair(d[0], 0));
    while(!st.empty()) {
        int v = st.begin()->second;
        st.erase(st.begin());
        for(size_t i = 0; i < g[v].size(); i++) {
            int u = g[v][i].first, w = g[v][i].second.first;
            if(d[v] + w < d[u]) {
                st.erase(make_pair(d[u], u));
                d[u] = d[v] + w;
                st.insert(make_pair(d[u], u));
            }
        }
    }
    dfs0(n - 1);
    for(int i = 0; i < n; i++)
        used[i] = false;
    dfs(0, -1);
    for(int i = 0; i < n; i++)
        used[i] = false;
    getPath(0, n - 1);
    cout << ans.size() << '\n';
    for(size_t i = 0; i < ans.size(); i++)
        cout << ans[i] + 1 << ' ';
    cout << '\n';
    return 0;
}
